/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.rbf.HandlerAlreadyRegisteredException;
import com.ibm.hwmca.fw.rbf.HandlerNotRegisteredException;
import com.ibm.hwmca.fw.rbf.RbfRequestType;
import com.ibm.hwmca.fw.rbf.impl.CommManager;
import com.ibm.hwmca.fw.rbf.impl.HandlerManager;
import com.ibm.hwmca.fw.rbf.impl.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestManager;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Set;

public final class RbfManager {
    private static final String TRACE_MASKT = "XRBFMGRT";
    private static final String TRACE_MASKF = "XRBFMGRF";
    private static final String TRACE_MASKD = "XRBFMGRD";
    private static RbfManager rbfManager = null;
    private HandlerManager handlerMgr = HandlerManager.getHandlerManager();

    private RbfManager() {
        Trace.trace(TRACE_MASKT, "<> RbfManager()");
    }

    public static synchronized RbfManager getRbfManager() {
        if (rbfManager == null) {
            rbfManager = new RbfManager();
        }
        return rbfManager;
    }

    public void registerHandler(Class handlerClass, RbfRequestType reqType) throws HandlerAlreadyRegisteredException, IllegalArgumentException {
        this.handlerMgr.registerLocalHandler(handlerClass, reqType);
    }

    public void deregisterHandler(RbfRequestType reqType) throws HandlerNotRegisteredException {
        this.handlerMgr.deregisterLocalHandler(reqType);
    }

    public Class getHandlerClass(RbfRequestType reqType) {
        return this.handlerMgr.getLocalHandlerClass(reqType);
    }

    public Set getPotentialHandlers(RbfRequestType reqType) {
        return this.handlerMgr.getHandlingMachines(reqType, 1);
    }

    public String getIpAddress(MachineId machineId) {
        return RbfUtils.getIpAddress(machineId);
    }

    public static class Init
    implements Runnable {
        public void run() {
            Trace.trace(RbfManager.TRACE_MASKT, "-> Initialization running");
            CommManager.getCommManager();
            try {
                RequestManager.getRequestManager();
            }
            catch (PersistenceNotInitializedException persistenceNotInitializedException) {
                // empty catch block
            }
            RbfManager.getRbfManager();
            Trace.trace(RbfManager.TRACE_MASKT, "<- Initialization ending");
        }
    }
}

